require( 'scripts/chocshopstyle.lua' );

TabPriceTextStyle = {
    x = 0,
    y = 0,
    w = kMax,
	h = kMax,
	flags = kHAlignCenter + kVAlignCenter,
	font = Prelevel_PriceFont,
};
TabPriceShadowStyle = {
    x = 2,
    y = 3,
    w = kMax,
	h = kMax,
	flags = kHAlignCenter + kVAlignCenter,
	font = Prelevel_PriceShadowFont,
};
TabInfoTextStyle = {
    x = kMax - 72,
    y = kMax - 30,
    w = 70,
	h = 28,
	flags = kHAlignCenter + kVAlignCenter,
	font = {edwardian_medium, 14, WhiteColor},
};
TabInfoShadowStyle = {
    x = kMax - 70,
    y = kMax - 28,
    w = 70,
	h = 28,
	flags = kHAlignCenter + kVAlignCenter,
	font = {edwardian_medium, 14, ShadowColor},
};

PriceButtonGroup = {
    RDisableButton {
	    name = "btn_buy_upgrade",
		x = kMax - 72,
		y = kMax - 28,
		w = 72,
		h = 28,
		graphics = {"ui/prelevel/price_btn_up","ui/prelevel/price_btn_down","ui/prelevel/price_btn_over"},
		SelectLayer(3),
		Bitmap{
		    image = "ui/prelevel/price_btn_disabled",
		    w = kMax,
		    h = kMax,
		},
		SelectLayer(-1),
		Text{
		    x = 2,
            y = 3,
            w = kMax,
	        h = kMax,
	        flags = kHAlignCenter + kVAlignCenter,
	        font = Prelevel_PriceShadowFont,
			name = "txt_price_shadow",
		},
		Text{
		    x = 0,
            y = 0,
            w = kMax,
	        h = kMax,
	        flags = kHAlignCenter + kVAlignCenter,
	        font = Prelevel_PriceFont,
	        name = "txt_price",
		},
	},	
};

MakeDialog{

	VUpgradeTab {
		name = "upgrade_tab",
		x = 0,
		y = 0,
		w = 235,
		h = 90,
		
		---------------------------------------------- Tab backgrounds
		SelectLayer(0),								-- Available
		Bitmap {
			x = 3,
			y = 3,
			name = "upgrade_back_avail",
			image = "ui/prelevel/upgrade_back_avail",
		},
		SelectLayer(1),								-- Over
		Bitmap {
			x = 3,
			y = 3,
			name = "upgrade_back_over",
			image = "ui/prelevel/upgrade_back_over",
		},
		SelectLayer(2),								-- Selected
		Bitmap {
			x = 3,
			y = 3,
			name = "upgrade_back_sel",
			image = "ui/prelevel/upgrade_back_over",
		},
		SelectLayer(3),								-- Locked
		Bitmap {
			x = 3,
			y = 3,
			name = "upgrade_back_locked",
			image = "ui/prelevel/upgrade_back_locked",
			SetStyle(TabInfoShadowStyle),
		    Text{
		        label = "prelevel_unavail",
		    },
		    SetStyle(TabInfoTextStyle),
		    Text{
			    label = "prelevel_unavail",
		    },
		},
		SelectLayer(4),								-- Purchsed
		Bitmap {
			x = 3,
			y = 3,
			name = "upgrade_back_over",
			image = "ui/prelevel/upgrade_back_purchased",
			SetStyle(TabInfoShadowStyle),
		    Text{
		        label = "prelevel_installed",
		    },
		    SetStyle(TabInfoTextStyle),
		    Text{
			    label = "prelevel_installed",
		    },
		},
		SelectLayer(-1),	
		Bitmap {
		    name = "img_thumbnail",
			x = 10,
			y = 0,
		},
		---------------------------------------------- Contents
		SelectLayer(-1),
		RWindow {
			x = 0,
			y = 0,
			w = kMax,
			h = kMax,
			name = "upgrade_contents",
			SetStyle(CSUpgradeTab_HeaderStyle),
			Text{
				x = 72,
				y = 12,
				w = 200,
				h = 65,
				name = "txt_header",
			},
			SetStyle(CSUpgradeTab_ContentStyle),
			Text{
				x = 72,
				y = 26,
				w = 160,
				h = 50,
				name = "txt_content",
			},
		},
		---------------------------------------------- Cost Button
        RDisableButton {
        --Button{
	        name = "btn_buy_upgrade",
		    x = kMax - 70,
		    y = kMax - 30,
		    w = 72,
		    h = 28,
		    graphics = {"ui/prelevel/price_btn_up","ui/prelevel/price_btn_down","ui/prelevel/price_btn_over"},
		    SelectLayer(3),
	        Bitmap{
	            image = "ui/prelevel/price_btn_disabled",
	            w = kMax,
	            h = kMax,
	        },
	        SelectLayer(-1),
		    Text{
		        x = 2,
                y = 3,
                w = kMax,
	            h = kMax,
	            flags = kHAlignCenter + kVAlignCenter,
	            font = Prelevel_PriceShadowFont,
			    name = "txt_price_shadow",
		    },
		    Text{
		        x = 0,
                y = 0,
                w = kMax,
	            h = kMax,
	            flags = kHAlignCenter + kVAlignCenter,
	            font = Prelevel_PriceFont,
	            name = "txt_price",
		    },
	    },	
		---------------------------------------------- Overlay Icon
		
		SelectLayer(2),								-- Selected
		Bitmap {
			x = 10,
			y = 8,
			name = "upgrade_icon_selected",
			image = "ui/prelevel/upgrade_icon_selected",
		},
		SelectLayer(3),								-- Locked
		Bitmap {
			x = 10,
			y = 8,
			name = "upgrade_icon_locked",
			image = "ui/prelevel/upgrade_icon_locked",
		},
	},
}

